/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.capabilities.race;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.Entity;
import xzeroair.trinkets.Trinkets;
import xzeroair.trinkets.capabilities.Capabilities;
import xzeroair.trinkets.client.keybinds.KeyHandler;
import xzeroair.trinkets.traits.AbilityHandler;
import xzeroair.trinkets.traits.abilities.interfaces.IAbilityInterface;
import xzeroair.trinkets.traits.abilities.interfaces.IMovementAbility;

public class KeybindHandler {
    private Map<String, KeyHandler> storage = new HashMap<String, KeyHandler>();

    public KeybindHandler() {
        this.addKeyBind(keyEnum.LEFT.getName());
        this.addKeyBind(keyEnum.RIGHT.getName());
        this.addKeyBind(keyEnum.FORWARD.getName());
        this.addKeyBind(keyEnum.BACK.getName());
        this.addKeyBind(keyEnum.JUMP.getName());
        this.addKeyBind(keyEnum.SNEAK.getName());
    }

    public void addKeyBind(String key) {
        if (!this.storage.containsKey(key)) {
            this.storage.put(key, new KeyHandler());
        }
    }

    public KeyHandler getKeyHandler(String key) {
        if (this.storage.containsKey(key)) {
            return this.storage.get(key);
        }
        KeyHandler kh = new KeyHandler();
        return this.storage.put(key, kh);
    }

    public boolean pressKey(Entity entity, String key, int state) {
        keyEnum KEY = keyEnum.byName(key);
        switch (KEY) {
            case LEFT: {
                return this.left(entity, state);
            }
            case RIGHT: {
                return this.right(entity, state);
            }
            case FORWARD: {
                return this.forward(entity, state);
            }
            case BACK: {
                return this.back(entity, state);
            }
            case JUMP: {
                return this.jump(entity, state);
            }
            case SNEAK: {
                return this.sneak(entity, state);
            }
        }
        return false;
    }

    public boolean left(Entity entity, int state) {
        return Capabilities.getEntityProperties(entity, true, (properties, bool) -> {
            Map<String, AbilityHandler.AbilityHolder> abilities = properties.getAbilityHandler().getActiveAbilities();
            for (Map.Entry<String, AbilityHandler.AbilityHolder> entry : abilities.entrySet()) {
                String key = entry.getKey();
                AbilityHandler.AbilityHolder holder = entry.getValue();
                try {
                    boolean cancel;
                    IAbilityInterface ability = holder.getAbility();
                    if (!(ability instanceof IMovementAbility) || (cancel = ((IMovementAbility)ability).left(entity, state))) continue;
                    return false;
                }
                catch (Exception e) {
                    Trinkets.log.error("Trinkets had an Error with Ability:" + key);
                    e.printStackTrace();
                }
            }
            return bool;
        });
    }

    public boolean right(Entity entity, int state) {
        return Capabilities.getEntityProperties(entity, true, (properties, bool) -> {
            Map<String, AbilityHandler.AbilityHolder> abilities = properties.getAbilityHandler().getActiveAbilities();
            for (Map.Entry<String, AbilityHandler.AbilityHolder> entry : abilities.entrySet()) {
                String key = entry.getKey();
                AbilityHandler.AbilityHolder holder = entry.getValue();
                try {
                    boolean cancel;
                    IAbilityInterface ability = holder.getAbility();
                    if (!(ability instanceof IMovementAbility) || (cancel = ((IMovementAbility)ability).right(entity, state))) continue;
                    return false;
                }
                catch (Exception e) {
                    Trinkets.log.error("Trinkets had an Error with Ability:" + key);
                    e.printStackTrace();
                }
            }
            return bool;
        });
    }

    public boolean forward(Entity entity, int state) {
        return Capabilities.getEntityProperties(entity, true, (properties, bool) -> {
            Map<String, AbilityHandler.AbilityHolder> abilities = properties.getAbilityHandler().getActiveAbilities();
            for (Map.Entry<String, AbilityHandler.AbilityHolder> entry : abilities.entrySet()) {
                String key = entry.getKey();
                AbilityHandler.AbilityHolder holder = entry.getValue();
                try {
                    boolean cancel;
                    IAbilityInterface ability = holder.getAbility();
                    if (!(ability instanceof IMovementAbility) || (cancel = ((IMovementAbility)ability).forward(entity, state))) continue;
                    return false;
                }
                catch (Exception e) {
                    Trinkets.log.error("Trinkets had an Error with Ability:" + key);
                    e.printStackTrace();
                }
            }
            return bool;
        });
    }

    public boolean back(Entity entity, int state) {
        return Capabilities.getEntityProperties(entity, true, (properties, bool) -> {
            Map<String, AbilityHandler.AbilityHolder> abilities = properties.getAbilityHandler().getActiveAbilities();
            for (Map.Entry<String, AbilityHandler.AbilityHolder> entry : abilities.entrySet()) {
                String key = entry.getKey();
                AbilityHandler.AbilityHolder holder = entry.getValue();
                try {
                    boolean cancel;
                    IAbilityInterface ability = holder.getAbility();
                    if (!(ability instanceof IMovementAbility) || (cancel = ((IMovementAbility)ability).back(entity, state))) continue;
                    return false;
                }
                catch (Exception e) {
                    Trinkets.log.error("Trinkets had an Error with Ability:" + key);
                    e.printStackTrace();
                }
            }
            return bool;
        });
    }

    public boolean jump(Entity entity, int state) {
        return Capabilities.getEntityProperties(entity, true, (properties, bool) -> {
            Map<String, AbilityHandler.AbilityHolder> abilities = properties.getAbilityHandler().getActiveAbilities();
            for (Map.Entry<String, AbilityHandler.AbilityHolder> entry : abilities.entrySet()) {
                String key = entry.getKey();
                AbilityHandler.AbilityHolder holder = entry.getValue();
                try {
                    boolean cancel;
                    IAbilityInterface ability = holder.getAbility();
                    if (!(ability instanceof IMovementAbility) || (cancel = ((IMovementAbility)ability).jump(entity, state))) continue;
                    return false;
                }
                catch (Exception e) {
                    Trinkets.log.error("Trinkets had an Error with Ability:" + key);
                    e.printStackTrace();
                }
            }
            return bool;
        });
    }

    public boolean sneak(Entity entity, int state) {
        return Capabilities.getEntityProperties(entity, true, (properties, bool) -> {
            Map<String, AbilityHandler.AbilityHolder> abilities = properties.getAbilityHandler().getActiveAbilities();
            for (Map.Entry<String, AbilityHandler.AbilityHolder> entry : abilities.entrySet()) {
                String key = entry.getKey();
                AbilityHandler.AbilityHolder holder = entry.getValue();
                try {
                    boolean cancel;
                    IAbilityInterface ability = holder.getAbility();
                    if (!(ability instanceof IMovementAbility) || (cancel = ((IMovementAbility)ability).sneak(entity, state))) continue;
                    return false;
                }
                catch (Exception e) {
                    Trinkets.log.error("Trinkets had an Error with Ability:" + key);
                    e.printStackTrace();
                }
            }
            return bool;
        });
    }

    public static enum keyEnum {
        LEFT("Left"),
        RIGHT("Right"),
        FORWARD("Forward"),
        BACK("Backward"),
        JUMP("Jump"),
        SNEAK("Sneak"),
        NONE("None");

        private String name;
        private static final keyEnum[] ID;

        private keyEnum(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static keyEnum byName(String name) {
            for (int i = 0; i < keyEnum.values().length; ++i) {
                if (!keyEnum.byID(i).getName().contentEquals(name)) continue;
                return keyEnum.byID(i);
            }
            return NONE;
        }

        public static keyEnum byID(int value) {
            if (value < 0 || value >= keyEnum.values().length) {
                value = 0;
            }
            return keyEnum.values()[value];
        }

        static {
            ID = new keyEnum[keyEnum.values().length];
        }
    }
}

